﻿using System;

using System.Collections.Generic;

using System.Threading;

using System.Linq;

using System.Text;

using Microsoft.ServiceHosting.ServiceRuntime;

using System.Configuration;

using Microsoft.ServiceBus.Samples;

using System.ServiceModel;

using System.ServiceModel.Description;

using Microsoft.ServiceBus;

using Microsoft.ServiceBus.Description;
using AzureSample;

 

namespace LogReceiverWorker
{
    public class WorkerRole : RoleEntryPoint
    {

        private ServiceHost host;



        public override void Start()
        {
            try
            {
                string userName = "proazure"; // ConfigurationSettings.AppSettings["UserName"];
                string password = "proazure";//  ConfigurationSettings.AppSettings["Password"];
                string calcEndPoint = "sb://proazure.servicebus.windows.net/sample/calc/";//ConfigurationSettings.AppSettings["EndPoint"];
                string logEndPoint = "sb://proazure.servicebus.windows.net/sample/log/";//ConfigurationSettings.AppSettings["EndPoint"];
                ServiceBusLogger logger = new ServiceBusLogger(logEndPoint, userName, password);
                logger.Channel.WriteToLog(DateTime.UtcNow, "Worker Role", "Role Started");

                Uri uri = new Uri(calcEndPoint);
                TransportClientEndpointBehavior userNamePasswordServiceBusCredential = new TransportClientEndpointBehavior();
                userNamePasswordServiceBusCredential.CredentialType = TransportClientCredentialType.UserNamePassword;
                userNamePasswordServiceBusCredential.Credentials.UserName.UserName = userName;
                userNamePasswordServiceBusCredential.Credentials.UserName.Password = password;
                host = new ServiceHost(typeof(CalculatorService), uri);
                logger.Channel.WriteToLog(DateTime.UtcNow, "Worker Role", "Service Host created");
                ContractDescription contractDescription = ContractDescription.GetContract(typeof(ICalculator), typeof(CalculatorService));
                ServiceEndpoint serviceEndPoint = new ServiceEndpoint(contractDescription);

                serviceEndPoint.Address = new EndpointAddress(uri);
                logger.Channel.WriteToLog(DateTime.UtcNow, "Worker Role", "Address created");

                serviceEndPoint.Binding = new NetTcpRelayBinding();

                logger.Channel.WriteToLog(DateTime.UtcNow, "Worker Role", "Binding created");

                //Set the DiscoveryType to Public and Publish this in the Service Registry
                ServiceRegistrySettings serviceRegistrySettings = new ServiceRegistrySettings();
                serviceRegistrySettings.DiscoveryMode = DiscoveryType.Public;
                serviceRegistrySettings.DisplayName = "My Calc Service";


                serviceEndPoint.Behaviors.Add(userNamePasswordServiceBusCredential);
                serviceEndPoint.Behaviors.Add(serviceRegistrySettings);

                logger.Channel.WriteToLog(DateTime.UtcNow, "Worker Role", "Added behaviors");

                
                host.Description.Endpoints.Add(serviceEndPoint);
                host.Open();
                logger.Channel.WriteToLog(DateTime.UtcNow, "Worker Role", "Host opened");

                while (true)
                {

                    Thread.Sleep(10000);
                    logger.Channel.WriteToLog(DateTime.UtcNow, "Worker Role", "Working…");


                }
            }
            catch (Exception ex)
            {

                RoleManager.WriteToLog("Error", "Error starting role " + ex.Message);
                RoleManager.WriteToLog("Error", "Stack Trace " + ex.StackTrace);
            }
        }



        public override void Stop()
        {

            host.Close();

            base.Stop();

        }



        public override RoleStatus GetHealthStatus()
        {

            // This is a sample worker implementation. Replace with your logic.

            return RoleStatus.Healthy;

        }

    }

}
